
markup.push({

// MARK: templates window

InspectorWindow:
{
	nsClass: "GXWindow",
	gxInitialWindowSize: "600, 610",	 // approx, for initial positioning
	gxInitialWindowPosition: "0.75, 0.5",
	gxWindowTitle: "Recording Inspector",
	gxSavedWindowStateKey: "inspectorWindow",
	gxBackColor: "BackColor1",
	gxFullSizeContentView: true,
	gxContentView: "InspectorWindowContentView",
},

// MARK: content view

InspectorWindowContentView:
{
	nsClass: "GXDrawView",
	gxFaceModel: {
		nsClass: "AH4AudioFileViewModel",
		gxFaceModelKeyPath: "faceModel",
	},
	gxLayout: [
		"V:|-(-1)-[barView(28)]-(-1)-[inspectorView]-(-1)-[bottomBar]-(-1)-|",
		"V:[barView]-(-1)-[emptyView]-(-1)-[bottomBar]",

		// playerGroup OR recordingGroup shown, they share the same area
		"V:|-0-[playerGroup]-(-1)-[infoGroup]-(-1)-[tagsGroup]-0-|",
		"V:|-0-[recordingGroup]-(-1)-[infoGroup]",

		//"V:|-0-[self]-0-|",

		"H:[self(>=540)]",		// sets window width

		"H:|-0-[inspectorView]-0-|",
		"H:|-0-[emptyView]-0-|",
	],
	gxChildViews:
	{
		barView:	// 'titleBarView' is handled specialy, 'barView' isn't
		{
			"+": "TitleBarView",
			gxChildViews:
			{
				windowTitle: {
					"+": "WindowTitle",
					axIsIgnored: false,
					gxDefaultValue: "Recording Inspector"
				},
			},
		},
		emptyView: { "+": "InspectorEmptyView" },
		inspectorView:
		{
			gxHideOnNilValue: true,	// value will be nil when no model object provided
			nsClass: "GXDrawView",
			gxBackPainter: "GroupViewBack",
			gxChildViews:
			{
				// playerGroup OR recordingGroup shown, they share the same area
				playerGroup: { "+": "PlayerView" },
				recordingGroup: { "+": "InspectorRecordingView" },
				infoGroup: { "+": "InfoView" },
				tagsGroup: { "+": "TagsView" },
			},
		},
		bottomBar: { "+": "InspectorBottomBar" },
	}
},

	
// MARK: player view
	
PlayerView:
{
	"+": "GroupView",
	//axTitle: "Player",
	axIsIgnored: true,
	gxHideOnNilValue: true, 	// value doesn't matter, but hideOnNil works when there is no model
	gxLayout:
	[
		"H:|-0-[self]-0-|",
		
		"H:|-13-[playBtn(34)]-3-[waveForm]-16-|&alignCenterY",
		"H:[playBtn]-3-[timeViews]-16-|",
				
		"V:|-11-[waveForm(>=80)]-1-[timeViews(17)]-10-|",		// sets height
		"V:[playBtn(70)]",

		"H:|-0-[elapsedTime(80)]-0-[spacer1]-0-[fileTimeLabel]-6-[fileTime(80)]-0-[spacer2]-0-[remainingTime(80)]-0-|&alignBaseline",
		"V:|-0-[elapsedTime]",
		// equal size the spacers
		"H:[spacer2(==spacer1)]",
	],
	gxChildViews:
	{
		playBtn:
        {
			nsClass: "GXButtonView",
			gxBackPainter: "ImagePainter.foreColor1.playbtn.large",
			gxValueKey: "filePlayBtn",
			gxLayerZPosition: 10,
            gxButtonType: "checkbox",
			axTitle: "play",
			axHelp: "play or pause this recording",
		},
        waveForm:
        {
            nsClass: "GXWaveView",
			gxValueKey: "playPosition",
			gxAnimateOnKey: "isPlaying",
            gxLayout: [
                "H:|-0-[fullWave]-0-|",
                "V:|-0-[fullWave]-0-|",

                "H:[playhead(2)]",
                "V:|-0-[playhead]-0-|",
            ],
            gxRootLayer:
            {
                nsClass: "GXDrawLayer",
                gxLayerZPosition: 2,
                gxSublayers:
                {
                    fullWave: {
                        nsClass: "GXWaveLayer",
                        gxLayerZPosition: 4,
                        gxValueKey: "waveData",
                        gxNeedsDisplayOnResize: true,
                        gxPainter: {    // only provides colors
                            nsClass: "GXPainter",
                            gxBackColor: "BackColor1",
                            gxFillColor: "ForeColor1",
                        },
                    },
                    playhead: {
                        // playhead is a puppet created for GXWaveView to use
                        nsClass: "GXDrawLayer",
                        gxLayerZPosition: 10,
                        gxBackPainter: {    // only used for colors
                            nsClass: "GXPainter",
                            gxCornerRadius: 1,
                            gxBackColor: "ColorThemeLive1",
                        },
                    },
                }
            }
        },
		timeViews:
		{
			nsClass: "GXDrawView",
			gxChildViews:
			{
				elapsedTime: {
					"+": "LabelView.left.foreColor1.withLive.size13",
					gxValueKey: "playTime",
					gxAnimateOnKey: "isPlaying",
					axIsIgnored: false,
					axTitle: "Elapsed Playing Time",
					gxFormatter: {
						nsClass: "GXTimeFormatter",
					},
				},
				fileTimeLabel: labelView("Duration:"),
				fileTime: {
					"+": "LabelView.left.foreColor1.size13",
					gxValueKey: "fileTime",
					gxAnimateOnKey: "isRecording",
					gxFormatter: { nsClass: "PTTrackTimeFormatter" },
					axTitle: "Duration",
					axIsIgnored: false,
				},
				remainingTime: {
					"+": "LabelView.right.foreColor1.withLive.size13",
					axIsIgnored: false,
					gxAnimateOnKey: "isPlaying",
					axTitle: "Remaining Play Time",
					gxFormatter: {
						nsClass: "GXTimeFormatter",
					},
				},
				spacer1: spacerView(),
				spacer2: spacerView(),
			},
		},
	},
},

	
// MARK: empty view

InspectorEmptyView:
{
	nsClass: "GXDrawView",
	gxBackPainter: "GroupViewBack",
	axIsIgnored: false,
	axDescription: "No Recording Selected",
	gxLayerZPosition: 10,
	gxLayout: [
		"H:|-0-[spacer1]-0-[label(200)]-0-[spacer2]-0-|",
		"V:|-0-[spacer1]-0-[image(80)]-2-[label]-0-[spacer2]-0-|",
		// image is 84*78. text ~200 wide
		"H:[spacer1]-50-[image(100)]",
		
		"H:[spacer2(==spacer1)]",
		"V:[spacer2(==spacer1)]",		
	],
	gxChildViews:
	{
		spacer1: spacerView(),
		spacer2: spacerView(),
		image: {
			nsClass: "GXDrawView",
			axIsIgnored: false,
			gxForePainter: "ImagePainter.foreColor3.empty-inspector",
			axDescription: "Recording in Progress",
		},
		label: labelView("No Recording Selected", "foreColor3.centerx.mediumWeight.size15"),
	},
},

	
// MARK: recording view

InspectorRecordingView:
{
	nsClass: "GXDrawView",
	gxHideOnNilValue: true,	// value doesn't matter, but hideOnNil works when there is no model
	gxLayerZPosition: 10,
	gxLayout: [
		"H:|-0-[self]-0-|",
		
		"H:|-0-[spacer1]-0-[statusBubble(250)]-0-[spacer2]-0-|",
		"V:|-0-[spacer1]-0-[image(80)]-0-[statusBubble(27)]-2-[spacer2]-0-|",
		// image is 84*78. text ~200 wide
		"H:[spacer1]-75-[image(100)]",
		
		"H:[spacer2(==spacer1)]",
		"V:[spacer2(==spacer1)]",
		"V:[spacer1(>=14)]",	// this sets minimum spacing, and thus overall height
		
	],
	gxChildViews:
	{
		spacer1: spacerView(),
		spacer2: spacerView(),
		image: {
			nsClass: "GXDrawView",
			axIsIgnored: false,
			gxForePainter: "ImagePainter.top.colorLive1.empty-inspector",
			axDescription: "Recording in Progress",
		},
		statusBubble:
		{
			nsClass: "GXDrawView",
			axIsIgnored: false,
			axTitle: "Current Recording Status",
			gxForePainter: {
				nsClass: "GXPainter",
				gxFillColor: "ColorThemeLive1.alphaBg",
				gxCornerRadius: 999,
			},
			gxLayout:
			[
				"H:|-6-[spinnerHost(21)]-4-[recordingStatus]-8-[duration(50)]-12-|",
			 
				"V:|-3-[spinnerHost(21)]",
				"V:|-5-[recordingStatus]",
				"V:|-5-[duration]",
			],
			gxChildViews:
			{
				spinnerHost:
				{
					nsClass: "GXLayerHostingView",
					gxRootLayer:
					{
						nsClass: "GXCaarLayer",
						gxViewName: "spinner",
						gxValueKey: "spinnerValue",
						gxAnimateOnKey: "isRecording",
						gxAnimationDivider: 2,
						gxCaarPainter: "RecordingSpinnerPainter",
						gxTransition: {
							nsClass: "GXSpinnerTransition",
							gxDuration: 1.0,
							gxRunOn: 1.0,
						},
					}
				},
				recordingStatus: {
					"+": "LabelView.useMarkup.top.left.boldWeight.colorThemeLive1.size13",
					gxAnimateOnKey: "isRecording",
					axIsIgnored: false,
					axTitle: "Status",
				},
				duration:
				{
					"+": "LabelView.top.right.colorThemeLive1.size13",
					gxValueKey: "fileTime",
					gxAnimateOnKey: "isRecording",
					gxFormatter: { nsClass: "PTTrackTimeFormatter" },
					axIsIgnored: false,
					axTitle: "Duration",
				},
			},
		},
	},
},

	
// MARK: info view

InfoView:
{
	"+": "GroupView",
	axTitle: "Information",
	axIsIgnored: false,
	gxLayout:
	[
		"H:|-0-[self]-0-|",
		
		"V:|-15-[fileNameLabel]-13-[fileSizeLabel]-15-|&alignLeft",
				
		"H:|-16-[fileNameLabel]-6-[fileName]-10-[revealBtn(80)]-16-|&alignBaseline",
		"H:|-16-[fileSizeLabel]-6-[fileSize(60)]-0-[spacer1]-0-[formatLabel]-6-[format(120)]-0-[spacer2]-0-[dateLabel]-6-[shortDate(120)]-16-|&alignBaseline",

//        "V:[fileSizeLabel]-2-[fileSize]-14-|&alignLeft",
//        "V:[formatLabel]-2-[format]-14-|&alignLeft",
//        "V:[dateLabel]-2-[shortDate]-14-|&alignLeft",

        // equal size the spacers
        "H:[spacer2(==spacer1)]",
	],
	gxChildViews:
	{
		fileNameLabel: labelView("File name:"),
		fileName: {
			"+": "BaseTextField",
			gxNilWhenEmpty: true,
			gxDisableOnNil: false,
			gxIsSingleLine: true,
			gxValueKey: "fileName",
			gxEditingKeyPath: "editingFileName",
			gxDisableOnKey: "disableEditing",
			axTitle: "File Name",
			axHelp: "VO press to edit file name",
			gxTextPainter: { "+": "ControlFore", gxHAlign: 0 },
			gxEdgeInsets: "2, 5, 2, 3",
			gxPencilForePainter: "PencilForePainter",
			gxPencilBackPainter: "PencilBackPainter",
			gxFocusRingPainter: "ControlBack",
			gxIntrinsicWidth: -1,
		},
		revealBtn: {
			"+": "ButtonView",
			gxTitle: "<icon16.foreColor1.action.reveal/> Reveal",
			gxForePainter: { "+": "ControlFore.useMarkup", gxEdgeInsets: "0, 0, 3, 0" },		// visually center title better
			gxDisableOnKey: "disableEditing",
			axHelp: "Reveals this recording in the Finder",
		},
		fileSizeLabel: labelView("Size:"),
		fileSize: {
			"+": "LabelView.left.foreColor1.withLive",
			gxValueKey: "fileSize",
			gxAnimateOnKey: "isRecording",
			gxFormatter: { nsClass: "PTFileSizeFormatter" },
			axTitle: "File Size",
			axIsIgnored: false,
		},
		formatLabel: labelView("Format:"),
		format: {
			"+": "LabelView.left.foreColor1.withLive",
			gxValueKey: "briefDescription",
			gxToolTipKeyPath: "fullDescription",
			axTitle: "File Format",
			axIsIgnored: false,
		},
		dateLabel: labelView("Recorded:", "left"),
		shortDate: {
			"+": "LabelView.foreColor1.withLive.left",
			axTitle: "Recorded Date",
			axIsIgnored: false,
		},
        // spacers
        spacer1: spacerView(),
        spacer2: spacerView(),
	}
},
	
	
// MARK: tags view
	
TagsView:
{
	"+": "ExpandingGroupView",
	gxValueKey: "tagsExpanded",
	//gxDefaultValue: true,
	gxCollapsedSize: 35,
	gxExtraSize: 14,
	axTitle: "Tags",
	gxLayout:
	[
		"H:|-0-[self]-0-|",
	 	"V:|-0-[expandBtn]-2-[title]",
	 	
	 	"V:[expandBtn]-2-[artwork(160)]",
	 	"H:[artwork(160)]-16-|",
	 
		"H:[titleLabel]-8-[title]&alignBaseline",
		"H:[title]-10-[artwork]",
	 	
	 	"H:[artistLabel]-8-[artist]&alignBaseline",
		"H:[artist]-10-[artwork]",
	 
		"H:|-16-[albumLabel]-8-[album]&alignBaseline",
	 	"H:[album]-10-[artwork]",

		"V:[title]-9-[artist]-9-[album]&alignLeft",

		"H:[trackLabel]-8-[track(34)]-8-[trackCountLabel]-8-[trackCount(34)]&alignBaseline",
		"H:[yearLabel]-8-[year(44)]-13-[compilation(100)]&alignBaseline",
        "H:[compilation]-(>=10)-[artwork]",
     
		"V:[year]-9-[genre]&alignLeft",
	 
		"H:[discLabel]-8-[disc(34)]-8-[discCountLabel]-8-[discCount(34)]-8-[genreLabel]-8-[genre(157)]&alignBaseline",
		"H:[genre]-(>=10)-[artwork]",
	 
		"V:[album]-9-[track]-9-[disc]&alignLeft",

	 	"H:|-16-[comment]-16-|",
		"V:[disc]-10-[comment(96)]",
	],
	gxChildViews:
	{
		expandBtn:
		{
			"+": "AdvancedGroupButton",
			gxTitle: "<disclosure/> Tags",
			//gxDefaultValue: true,
			gxValueKey: "tagsExpanded",
			axFormatter: disclosureAxFormatter("Tags"),
			gxDisableOnNil: true,
		},
		titleLabel: labelView("Title:"),
		title: {
			"+": "DarkTextField",
			gxNilWhenEmpty: true,
			gxDisableOnNil: false,
			gxIsSingleLine: true,
			gxValueKey: "fileTags.title",
			axTitle: "Track Title",
			gxDisableOnKey: "disableEditing",
		},
		artistLabel: labelView("Artist:"),
		artist: {
			"+": "DarkTextField",
			gxNilWhenEmpty: true,
			gxDisableOnNil: false,
			gxValueKey: "fileTags.artist",
			axTitle: "Artist",
			gxDisableOnKey: "disableEditing",
		},
		albumLabel: labelView("Album:"),
		album: {
			"+": "DarkTextField",
			gxNilWhenEmpty: true,
			gxDisableOnNil: false,
			gxValueKey: "fileTags.album",
			axTitle: "Album",
			gxDisableOnKey: "disableEditing",
		},
		artwork: {
			"+": "ArtView",
			gxValueKey: "fileTags.albumArt",
			gxDisableOnKey: "disableEditing",
			axTitle: "Album Art",
		},
		yearLabel: labelView("Year:"),
		year: {
			"+": "DarkNumberField",
			gxRangeMax: 9999,
			gxValueKey: "fileTags.year",
			axTitle: "Year",
			gxDisableOnKey: "disableEditing",
		},
		trackLabel: labelView("Track:"),
		track: {
			"+": "DarkNumberField",
			gxValueKey: "fileTags.track",
			axTitle: "Track Number",
			gxDisableOnKey: "disableEditing",
		},
		trackCountLabel: labelView("of:"),
		trackCount: {
			"+": "DarkNumberField",
			gxValueKey: "fileTags.trackCount",
			axTitle: "Track Count",
			gxDisableOnKey: "disableEditing",
		},
		genreLabel: labelView("Genre:"),
		genre: {
			"+": "GenrePopupMenu",
			gxValueKey: "fileTags.genre",
			axTitle: "Genre",
			gxDisableOnKey: "disableEditing",
		},
		discLabel: labelView("Disc:"),
		disc: {
			"+": "DarkNumberField",
			gxValueKey: "fileTags.disc",
			axTitle: "Disc Number",
			gxDisableOnKey: "disableEditing",
		},
		discCountLabel: labelView("of:"),
		discCount: {
			"+": "DarkNumberField",
			gxValueKey: "fileTags.discCount",
			axTitle: "Disc Count",
			gxDisableOnKey: "disableEditing",
		},
		compilation: {
			"+": "CheckboxTemplate",
			gxValueKey: "fileTags.partOfCompilation",
			gxTitle: "<checkbox/> Compilation",
			gxDisableOnNil: false,
			gxDisableOnKey: "disableEditing",
		},
		comment: {
			"+": "DarkTextField.multiline",
			gxValueKey: "fileTags.comment",
			gxPlaceholderString: "Comments",
			axTitle: "Comments",
			gxDisableOnKey: "disableEditing",
		},
	}
},


// MARK: bottom bar

InspectorBottomBar:
{
	"+": "GroupView",
	axTitle: "Info Section",
	gxLayout:
	[
		"H:|-0-[self]-0-|",
		"V:|-14-[editorBtn]-14-|",

		"H:|-16-[editorBtn(75)]-9-[musicBtn(80)]-9-[inspectorShareBtn(90)]-(>=9)-[trashBtn(80)]-16-|&alignCenterY",
	 ],
	gxChildViews:
	{
		editorBtn: {
			"+": "ButtonView.useMarkup",
			gxTitle: "<icon.foreColor1.action.edit/> Edit ",
            gxDisableOnKey: "disableEditing",
			axHelp: "Opens this recording in an Editor, set in Prefernces",
		},
        musicBtn: {
			"+": "ButtonView.useMarkup",
            gxDisableOnKey: "disableEditing",
			gxTitle: "<icon.foreColor1.action.music/> Music ",
			axHelp: "Adds this recording to Music.app",
		},
        inspectorShareBtn: {
            "+": "PopupMenuTemplate.useMarkup",
            gxTitle: "<icon.foreColor1.action.share/> Share",
            gxMenuItemsKeyPath: "inspectorShareBtnMenuItems",
            gxHideOnNilValue: false,
			gxDisableOnNil: true,
			gxDisableOnKey: "disableEditing",
			axTitle: "Share"
        },
		trashBtn: {
			"+": "ButtonView.useMarkup",
			gxTitle: "<icon.foreColor1.action.delete/> Trash ",
            gxDisableOnKey: "disableEditing",
			axHelp: "Removes this recording from Audio Hijack and optionally throws in the trash",
		},
	}
},

	
})
